#ifndef __CThreadManager__
#define __CThreadManager__

#include "IThread.hpp"

//	===========================================================================

using Exponent::Threading::IThread;

//	===========================================================================

namespace Exponent
{
	namespace Threading
	{
		/**
		 * @class CThreadManager CThreadManager.hpp
		 * @brief Handles start and processing of threads
		 *
		 * @date 13/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CThreadManager.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CThreadManager
		{
		public:

			/**
			 * Start a thread
			 * @param thread The thread to start
			 * @code
			 * // We want to start a thread, we first create the object that is going to be run in the thread. Note that this <B>IS NOT REFERENCE COUNTED!</B>
			 * // In normal usage, we create this local or as a member variable
			 * CMyThreadedObject object;
			 * CThreadManager::startThread(&object);
			 * // Thread now run in background and you will be notified of events through the delegate
			 * @endcode
			 */
			static void startThread(IThread *thread);

			/**
			 * Stop a thread
			 * @param thread The thread to stop
			 */
			static void stopThread(IThread *thread);

			/**
			 * Force terminate a thread
			 * @param thread The thread to terminate. Causes immediate termination of all actions. You will not have a chance to complete anything..
			 */
			static void terminateThread(IThread *thread);

//	===========================================================================

		protected:

//	===========================================================================

#ifdef WIN32
			/**
			 * Windows thread call back function
			 * @param data Hopefully the IThread object..
			 */
			static unsigned long __stdcall threadCallback(void *data);
#else
			/**
			 * Macintosh (POSIX pthread) callback function
			 * @param data Hopefully the IThread object...
			 * @retval void * defined by posix. We return NULL??
			 */
			static void *threadCallback(void *data);
#endif
		};
	}
}
#endif		// End of CThreadManager.hpp